/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.items.complex;

import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.api.v2.advancement.AdvancementManager;
import org.betterx.bclib.items.complex.EquipmentDescription;
import org.betterx.bclib.items.complex.EquipmentSet;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.betternether.items.NetherArmor;
import org.betterx.betternether.items.NetherAxe;
import org.betterx.betternether.items.NetherHoe;
import org.betterx.betternether.items.NetherPickaxe;
import org.betterx.betternether.items.NetherShovel;
import org.betterx.betternether.items.NetherSword;
import org.betterx.betternether.items.materials.BNToolMaterial;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;

public class NetherSet
extends EquipmentSet {
    public NetherSet(String prefix, BNToolMaterial material, ArmorMaterial armor, boolean withShears) {
        this(prefix, null, material, armor, withShears);
    }

    public NetherSet(String prefix, EquipmentSet sourceSet, BNToolMaterial material, ArmorMaterial armor, boolean withShears) {
        super((Tier)material, "betternether", prefix, (ItemLike)NetherBlocks.NETHER_REED_STEM, sourceSet, material.attackDamages, material.attackSpeeds);
        this.add(PICKAXE_SLOT, EquipmentDescription::new, NetherPickaxe::new);
        this.add(AXE_SLOT, EquipmentDescription::new, NetherAxe::new);
        this.add(SHOVEL_SLOT, EquipmentDescription::new, NetherShovel::new);
        this.add(HOE_SLOT, EquipmentDescription::new, NetherHoe::new);
        this.add(SWORD_SLOT, EquipmentDescription::new, NetherSword::new);
        this.add(HELMET_SLOT, new EquipmentDescription(HELMET_SLOT, tier -> new NetherArmor(armor, ArmorItem.Type.HELMET)));
        this.add(CHESTPLATE_SLOT, new EquipmentDescription(CHESTPLATE_SLOT, tier -> new NetherArmor(armor, ArmorItem.Type.CHESTPLATE)));
        this.add(LEGGINGS_SLOT, new EquipmentDescription(LEGGINGS_SLOT, tier -> new NetherArmor(armor, ArmorItem.Type.LEGGINGS)));
        this.add(BOOTS_SLOT, new EquipmentDescription(BOOTS_SLOT, tier -> new NetherArmor(armor, ArmorItem.Type.BOOTS)));
        if (withShears) {
            this.add(SHEARS_SLOT, new EquipmentDescription(SHEARS_SLOT, tier -> new BaseShearsItem(NetherItems.defaultSettings().m_41503_((int)((double)material.m_6609_() * 0.75)))));
        }
    }

    public NetherSet init() {
        super.init(NetherItems.getItemRegistry());
        return this;
    }

    public AdvancementManager.Builder addArmorSet(AdvancementManager.Builder builder) {
        return builder.addInventoryChangedCriterion(this.baseName + "_" + HELMET_SLOT, new ItemLike[]{this.getSlot(HELMET_SLOT)}).addInventoryChangedCriterion(this.baseName + "_" + CHESTPLATE_SLOT, new ItemLike[]{this.getSlot(CHESTPLATE_SLOT)}).addInventoryChangedCriterion(this.baseName + "_" + LEGGINGS_SLOT, new ItemLike[]{this.getSlot(LEGGINGS_SLOT)}).addInventoryChangedCriterion(this.baseName + "_" + BOOTS_SLOT, new ItemLike[]{this.getSlot(BOOTS_SLOT)});
    }
}

